<?php
require_once __DIR__.'/db.php';

/** Generate a random plan respecting unit & max/day */
function generate_plan($total_amount, $days, $unit = 50, $max_daily = 2000) {
    $total_amount = (int)$total_amount;
    $days = max(1, (int)$days);
    $unit = max(1, (int)$unit);
    $max_daily = max($unit, (int)$max_daily);

    $target_units = intdiv($total_amount, $unit);
    if ($target_units * $unit != $total_amount) {
        $total_amount = $target_units * $unit;
    }
    $max_units = max(1, intdiv($max_daily, $unit));
    $parts = [];
    $remaining = $target_units;

    for ($i=0; $i < $days - 1; $i++) {
        $max_choice = min($max_units, $remaining - ($days - $i - 1));
        $val = rand(1, max(1,$max_choice));
        $parts[] = $val;
        $remaining -= $val;
    }
    $parts[] = $remaining;

    // shuffle for randomness
    for ($i=0; $i<count($parts); $i++) {
        $j = rand(0, count($parts)-1);
        $tmp = $parts[$i]; $parts[$i] = $parts[$j]; $parts[$j] = $tmp;
    }

    $amounts = array_map(function($u) use ($unit){ return $u*$unit; }, $parts);
    // final adjust
    $diff = $total_amount - array_sum($amounts);
    if ($diff != 0) $amounts[count($amounts)-1] += $diff;
    // cap to max and repair if any overflow (rare)
    for ($i=0; $i<count($amounts); $i++) {
        if ($amounts[$i] > $max_daily) {
            $ex = $amounts[$i] - $max_daily;
            $amounts[$i] = $max_daily;
            for ($k=0; $k<count($amounts) && $ex>0; $k++) {
                if ($amounts[$k] + $unit <= $max_daily) {
                    $amounts[$k] += $unit;
                    $ex -= $unit;
                }
            }
        }
    }
    // ensure sum still matches
    $sum = array_sum($amounts);
    if ($sum != $total_amount) {
        $idx = 0;
        while ($sum < $total_amount && $idx < count($amounts)) {
            if ($amounts[$idx] + $unit <= $max_daily) { $amounts[$idx] += $unit; $sum += $unit; }
            $idx++;
            if ($idx==count($amounts)) $idx=0;
        }
        while ($sum > $total_amount) {
            if ($amounts[$idx] - $unit >= $unit) { $amounts[$idx] -= $unit; $sum -= $unit; }
            $idx++; if ($idx==count($amounts)) $idx=0;
        }
    }
    return $amounts;
}

function save_plan_to_db($wallet_id, $amounts) {
    global $pdo;
    $pdo->prepare("DELETE FROM wallet_plan WHERE wallet_id = ?")->execute([$wallet_id]);
    $stmt = $pdo->prepare("INSERT INTO wallet_plan (wallet_id, day_no, amount) VALUES (?,?,?)");
    foreach ($amounts as $i=>$amt) { $stmt->execute([$wallet_id, $i+1, $amt]); }
}

function send_telegram_message($bot_token, $chat_id, $text) {
    $url = "https://api.telegram.org/bot{$bot_token}/sendMessage";
    $data = ['chat_id'=>$chat_id, 'text'=>$text, 'parse_mode'=>'HTML'];
    $options = ['http'=>[
        'header'=>"Content-type: application/x-www-form-urlencoded\r\n",
        'method'=>'POST',
        'content'=>http_build_query($data)
    ]];
    $context = stream_context_create($options);
    @file_get_contents($url, false, $context);
}
