<?php
require_once __DIR__.'/../inc/auth.php';
require_once __DIR__.'/../inc/functions.php';
require_once __DIR__.'/../inc/db.php';
require_login();
require_once __DIR__.'/_header.php';
$uid=current_user_id();
$msg='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  $name=trim($_POST['name']);
  $goal=(int)$_POST['goal_amount'];
  $days=(int)$_POST['days'];
  $max_daily=(int)$_POST['max_daily'];
  $unit=(int)($_POST['unit']??50);
  $upi=trim($_POST['upi_id']);
  $tg=trim($_POST['telegram_chat_id']);
  if($name && $goal>0 && $days>0 && $max_daily>0){
    $stmt=$pdo->prepare("INSERT INTO wallets (user_id,name,goal_amount,days,max_daily,unit,upi_id,telegram_chat_id) VALUES (?,?,?,?,?,?,?,?)");
    $stmt->execute([$uid,$name,$goal,$days,$max_daily,$unit,$upi,$tg]);
    $wid=$pdo->lastInsertId();
    $amounts=generate_plan($goal,$days,$unit,$max_daily);
    save_plan_to_db($wid,$amounts);
    header("Location: view_wallet.php?id=".$wid); exit;
  } else { $msg='Please fill required fields'; }
}
?>
<div class="max-w-2xl mx-auto bg-white p-6 rounded-2xl glow">
  <h1 class="text-2xl font-bold mb-3">Create New Wallet</h1>
  <?php if($msg):?><div class="text-red-600 mb-2"><?=htmlspecialchars($msg)?></div><?php endif;?>
  <form method="post" class="grid md:grid-cols-2 gap-4">
    <label class="block">Wallet Name<input name="name" class="w-full p-3 border rounded"></label>
    <label class="block">Goal Amount (₹)<input type="number" name="goal_amount" value="100000" class="w-full p-3 border rounded"></label>
    <label class="block">Days<input type="number" name="days" value="100" class="w-full p-3 border rounded"></label>
    <label class="block">Max/day (₹)<input type="number" name="max_daily" value="2000" class="w-full p-3 border rounded"></label>
    <label class="block">Multiples (₹)<input type="number" name="unit" value="50" class="w-full p-3 border rounded"></label>
    <label class="block">UPI ID<input name="upi_id" placeholder="name@bank" class="w-full p-3 border rounded"></label>
    <label class="block md:col-span-2">Telegram chat_id <input name="telegram_chat_id" placeholder="e.g. 123456789" class="w-full p-3 border rounded"></label>
    <div class="md:col-span-2 flex justify-end">
      <a href="index.php" class="mr-2 px-4 py-2 rounded border">Cancel</a>
      <button class="bg-gradient-to-r from-blue-600 to-purple-600 text-white px-4 py-2 rounded shadow">Create</button>
    </div>
  </form>
</div>
<?php require_once __DIR__.'/_footer.php'; ?>
