<?php
require_once __DIR__.'/../inc/db.php';
require_once __DIR__.'/../inc/auth.php';
require_once __DIR__.'/_header.php';

$err='';
if ($_SERVER['REQUEST_METHOD']==='POST') {
    if ($_POST['action']==='register') {
        $u=trim($_POST['username']); $p=$_POST['password'];
        if($u && $p){
            $hash=password_hash($p,PASSWORD_DEFAULT);
            try{ $pdo->prepare("INSERT INTO users (username,password_hash) VALUES (?,?)")->execute([$u,$hash]); }
            catch(Exception $e){ $err="Username taken."; }
        } else $err="Fill all fields.";
    }
    if ($_POST['action']==='login'){
        $u=trim($_POST['username']); $p=$_POST['password'];
        $st=$pdo->prepare("SELECT * FROM users WHERE username=?"); $st->execute([$u]);
        $user=$st->fetch(PDO::FETCH_ASSOC);
        if($user && password_verify($p,$user['password_hash'])){ $_SESSION['user_id']=$user['id']; header("Location: /public/index.php"); exit; }
        else $err="Invalid credentials";
    }
}

if(!is_logged_in()): ?>
<div class="grid md:grid-cols-2 gap-6">
  <form method="post" class="bg-white p-6 rounded-2xl glow fade-in">
    <h2 class="text-2xl font-bold mb-4">Welcome to Dream Wallet</h2>
    <?php if($err): ?><div class="text-red-600 mb-2"><?=htmlspecialchars($err)?></div><?php endif;?>
    <input name="username" placeholder="Username" class="w-full p-3 border rounded mb-2">
    <input name="password" type="password" placeholder="Password" class="w-full p-3 border rounded mb-4">
    <input type="hidden" name="action" value="login">
    <button class="bg-blue-600 hover:bg-blue-700 transition text-white px-4 py-2 rounded">Login</button>
  </form>
  <form method="post" class="bg-white p-6 rounded-2xl glow fade-in">
    <h2 class="text-2xl font-bold mb-4">Create Account</h2>
    <input name="username" placeholder="Choose username" class="w-full p-3 border rounded mb-2">
    <input name="password" type="password" placeholder="Choose password" class="w-full p-3 border rounded mb-4">
    <input type="hidden" name="action" value="register">
    <button class="bg-purple-600 hover:bg-purple-700 transition text-white px-4 py-2 rounded">Register</button>
  </form>
</div>
<?php else:
$uid = current_user_id();
$st=$pdo->prepare("SELECT * FROM wallets WHERE user_id=? ORDER BY id DESC"); $st->execute([$uid]); $wallets=$st->fetchAll(PDO::FETCH_ASSOC);
?>
<div class="flex justify-between items-center mb-4">
  <h1 class="text-3xl font-extrabold">Your Wallets</h1>
  <div>
    <a href="create_wallet.php" class="bg-gradient-to-r from-blue-600 to-purple-600 text-white px-4 py-2 rounded-lg shadow">Create New Wallet</a>
    <a href="logout.php" class="ml-2 text-sm text-red-600">Logout</a>
  </div>
</div>
<?php if(!$wallets): ?>
  <div class="bg-white p-6 rounded-2xl glow">No wallets yet. Click <em>Create New Wallet</em>.</div>
<?php else: ?>
  <div class="grid md:grid-cols-2 gap-4">
    <?php foreach($wallets as $w): 
      // compute progress
      $p=$pdo->prepare("SELECT SUM(amount) as total, SUM(CASE WHEN paid=1 THEN amount ELSE 0 END) as paid FROM wallet_plan WHERE wallet_id=?");
      $p->execute([$w['id']]); $agg=$p->fetch(PDO::FETCH_ASSOC);
      $total=$agg['total']?:0; $paid=$agg['paid']?:0; $pct=$total?floor(($paid/$total)*100):0;
    ?>
    <a href="view_wallet.php?id=<?=$w['id']?>" class="block bg-white p-5 rounded-2xl glow hover:scale-[1.01] transition">
      <div class="flex items-center gap-4">
        <svg width="80" height="80">
          <circle cx="40" cy="40" r="34" stroke="#E5E7EB" stroke-width="8" fill="none"></circle>
          <circle cx="40" cy="40" r="34" stroke="url(#grad<?=$w['id']?>)" stroke-width="8" fill="none"
                  stroke-dasharray="<?=2*3.1416*34?>" stroke-dashoffset="<?=2*3.1416*34*(1-$pct/100)?>" class="ring-progress"></circle>
          <defs>
            <linearGradient id="grad<?=$w['id']?>" x1="0" y1="0" x2="1" y2="1">
              <stop offset="0%" stop-color="#2563EB"/>
              <stop offset="100%" stop-color="#6D28D9"/>
            </linearGradient>
          </defs>
        </svg>
        <div>
          <div class="text-lg font-bold"><?=htmlspecialchars($w['name'])?></div>
          <div class="text-sm text-gray-600">Progress: <?=$pct?>% • Goal ₹<?=number_format($w['goal_amount'])?></div>
          <div class="text-xs text-gray-500">Max/day ₹<?=$w['max_daily']?> • Days <?=$w['days']?></div>
        </div>
      </div>
    </a>
    <?php endforeach; ?>
  </div>
<?php endif; endif; 

require_once __DIR__.'/_footer.php';
